import { StarXpandCommand } from "star-io10-web";

export class LabelSample02_For203dpiAnd300dpi_DrinkLabel1 {
  static async createPrintCommands(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder().addPrinter(
        new StarXpandCommand.PrinterBuilder()
          .styleBold(true)
          .actionPrintText("Item:   1 of 3\n")
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleMagnification(
                new StarXpandCommand.MagnificationParameter(1, 2),
              )
              .actionPrintText("* Jane Smith *\n" + "Gr Icd Coffee\n"),
          )
          .actionPrintText(
            "No Classic\n" +
              "With Whole Milk\n" +
              "\n" +
              "Time:   4:14:29 PM\n" +
              "Reg:    9\n" +
              "\n" +
              "--------------------------------\n",
          )
          .add(
            new StarXpandCommand.PrinterBuilder()
              .styleBold(true)
              .actionPrintText(">MOBILE<\n"),
          )
          .actionPrintText("--------------------------------\n")
          .actionCut(StarXpandCommand.Printer.CutType.Partial),
      ),
    );

    return await builder.getCommands();
  }
}
